<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<!-- Modern Activities Section -->
<div class="activities-section" style="
    min-height: 100vh; 
    background: linear-gradient(135deg, #F0F8FF 0%, #E6F3FF 50%, #DBEAFE 100%);
    padding: 100px 0 50px 0;
">
    <div class="container">
        <!-- Page Header -->
        <div class="page-header text-center mb-5">
            <h1 class="page-title" style="
                color: #1E3A8A; 
                font-size: 3rem; 
                font-weight: 700; 
                margin-bottom: 1rem;
                background: linear-gradient(135deg, #1E3A8A 0%, #4169E1 50%, #87CEEB 100%);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
            ">
                <i class="bi bi-calendar-event me-3" style="color: #4169E1;"></i>
                Daily Activities
            </h1>
            <p style="color: #1E3A8A; font-size: 1.2rem;">Explore my daily activities and achievements</p>
        </div>

        <!-- Search and Filter Section -->
        <div class="filter-section mb-5" style="
            background: rgba(255, 255, 255, 0.95); 
            border: 1px solid rgba(135, 206, 235, 0.3); 
            border-radius: 20px; 
            padding: 2rem;
            box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
        ">
            <form method="GET" action="<?= base_url('activities') ?>" class="row g-3">
                <div class="col-md-4">
                    <label for="search" class="form-label" style="color: #1E3A8A; font-weight: 600;">
                        <i class="bi bi-search me-2" style="color: #4169E1;"></i>Cari Aktivitas
                    </label>
                    <input type="text" class="form-control modern-input" id="search" name="search" 
                           value="<?= esc($search) ?>" placeholder="Cari nama aktivitas...">
                </div>
                <div class="col-md-3">
                    <label for="tanggal_dari" class="form-label" style="color: #1E3A8A; font-weight: 600;">
                        <i class="bi bi-calendar me-2" style="color: #87CEEB;"></i>From Date
                    </label>
                    <input type="date" class="form-control modern-input" id="tanggal_dari" name="tanggal_dari" 
                           value="<?= esc($filter['tanggal_dari']) ?>">
                </div>
                <div class="col-md-3">
                    <label for="tanggal_sampai" class="form-label" style="color: #1E3A8A; font-weight: 600;">
                        <i class="bi bi-calendar-check me-2" style="color: #00BFFF;"></i>To Date
                    </label>
                    <input type="date" class="form-control modern-input" id="tanggal_sampai" name="tanggal_sampai" 
                           value="<?= esc($filter['tanggal_sampai']) ?>">
                </div>
                <div class="col-md-2">
                    <label for="sort" class="form-label" style="color: #1E3A8A; font-weight: 600;">
                        <i class="bi bi-sort me-2" style="color: #FFB6C1;"></i>Sort By
                    </label>
                    <select class="form-select modern-input" id="sort" name="sort">
                        <option value="tanggal" <?= $sort === 'tanggal' ? 'selected' : '' ?>>Date</option>
                        <option value="jam" <?= $sort === 'jam' ? 'selected' : '' ?>>Time</option>
                        <option value="nama_aktivitas" <?= $sort === 'nama_aktivitas' ? 'selected' : '' ?>>Activity Name</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="order" class="form-label" style="color: #1E3A8A; font-weight: 600;">
                        <i class="bi bi-arrow-up-down me-2" style="color: #DDA0DD;"></i>Order
                    </label>
                    <select class="form-select modern-input" id="order" name="order">
                        <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>Newest</option>
                        <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>Oldest</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn-modern btn-primary w-100">
                        <i class="bi bi-funnel me-2"></i>Terapkan Filter
                    </button>
                </div>
            </form>
        </div>

        <!-- Activities Grid -->
        <?php if (empty($activities)): ?>
            <div class="empty-state text-center" style="
                background: rgba(255, 255, 255, 0.9); 
                border: 1px solid rgba(135, 206, 235, 0.3); 
                border-radius: 20px; 
                padding: 4rem 2rem;
                box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
            ">
                <i class="bi bi-calendar-x" style="font-size: 4rem; color: #4169E1; margin-bottom: 1rem;"></i>
                <h3 style="color: #1E3A8A; margin-bottom: 1rem;">Tidak Ada Aktivitas Ditemukan</h3>
                <p style="color: #1E3A8A; opacity: 0.8;">Coba sesuaikan kriteria pencarian atau periksa kembali nanti.</p>
            </div>
        <?php else: ?>
            <div class="activities-grid row g-4">
                <?php foreach ($activities as $activity): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="activity-card-modern" style="
                            background: rgba(255, 255, 255, 0.95); 
                            border: 1px solid rgba(135, 206, 235, 0.3); 
                            border-radius: 20px; 
                            overflow: hidden;
                            box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
                            transition: all 0.3s ease;
                            height: 100%;
                        " onmouseover="this.style.transform='translateY(-10px)'; this.style.boxShadow='0 15px 35px rgba(65, 105, 225, 0.2)'" 
                           onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 8px 25px rgba(65, 105, 225, 0.1)'">
                            
                            <!-- Activity Image -->
                            <div class="activity-image-container" style="height: 220px; overflow: hidden; position: relative;">
                                <?php if ($activity['foto']): ?>
                                    <img src="<?= image_url('activities', $activity['foto'], 400, 220) ?>" 
                                         class="w-100 h-100 image-clickable" alt="<?= esc($activity['nama_aktivitas']) ?>"
                                         data-full-image="<?= assets_image_url('activities', $activity['foto']) ?>"
                                         style="object-fit: cover; cursor: pointer; transition: transform 0.3s ease;"
                                         onerror="this.src='<?= base_url('placeholder/400/220') ?>'; this.onerror=null;"
                                         onmouseover="this.style.transform='scale(1.1)'"
                                         onmouseout="this.style.transform='scale(1)'">
                                    
                                    <!-- Image Overlay -->
                                    <div class="image-overlay position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" 
                                         style="background: rgba(65, 105, 225, 0.8); opacity: 0; transition: opacity 0.3s ease;"
                                         onmouseover="this.style.opacity='1'"
                                         onmouseout="this.style.opacity='0'">
                                        <i class="bi bi-zoom-in text-white" style="font-size: 2rem;"></i>
                                    </div>
                                <?php else: ?>
                                    <div class="activity-placeholder d-flex align-items-center justify-content-center w-100 h-100" 
                                         style="background: linear-gradient(135deg, #87CEEB, #4169E1);">
                                        <i class="bi bi-image text-white" style="font-size: 3rem;"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <!-- Date Badge -->
                                <div class="date-badge position-absolute" style="
                                    top: 15px; 
                                    right: 15px; 
                                    background: rgba(255, 255, 255, 0.95); 
                                    color: #1E3A8A; 
                                    padding: 8px 12px; 
                                    border-radius: 12px; 
                                    font-size: 0.85rem; 
                                    font-weight: 600;
                                    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                                ">
                                    <?= date('M d', strtotime($activity['tanggal'])) ?>
                                </div>
                            </div>
                            
                            <!-- Activity Content -->
                            <div class="activity-content p-3">
                                <h5 style="color: #1E3A8A; font-weight: 600; margin-bottom: 1rem; line-height: 1.3;">
                                    <?= esc($activity['nama_aktivitas']) ?>
                                </h5>
                                
                                <!-- Activity Meta -->
                                <div class="activity-meta mb-3">
                                    <div class="d-flex align-items-center mb-2">
                                        <div class="meta-item d-flex align-items-center me-3" style="
                                            background: rgba(240, 248, 255, 0.8); 
                                            padding: 4px 8px; 
                                            border-radius: 8px;
                                            border-left: 3px solid #4169E1;
                                        ">
                                            <i class="bi bi-calendar3 me-1" style="color: #4169E1; font-size: 0.9rem;"></i>
                                            <span style="color: #1E3A8A; font-size: 0.85rem; font-weight: 500;">
                                                <?= date('d F Y', strtotime($activity['tanggal'])) ?>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <div class="meta-item d-flex align-items-center" style="
                                            background: rgba(240, 248, 255, 0.8); 
                                            padding: 4px 8px; 
                                            border-radius: 8px;
                                            border-left: 3px solid #87CEEB;
                                        ">
                                            <i class="bi bi-clock me-1" style="color: #87CEEB; font-size: 0.9rem;"></i>
                                            <span style="color: #1E3A8A; font-size: 0.85rem; font-weight: 500;">
                                                <?= date('H:i', strtotime($activity['jam'])) ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Activity Description -->
                                <?php if ($activity['deskripsi']): ?>
                                    <p style="color: #1E3A8A; font-size: 0.95rem; line-height: 1.6; margin-bottom: 1rem;">
                                        <?= esc(substr($activity['deskripsi'], 0, 120)) ?><?= strlen($activity['deskripsi']) > 120 ? '...' : '' ?>
                                    </p>
                                <?php endif; ?>
                                
                                <!-- Video Button -->
                                <?php if ($activity['video']): ?>
                                    <div class="activity-actions">
                                        <button class="btn-modern btn-video" 
                                                onclick="showVideoModal('<?= assets_image_url('activities', $activity['video']) ?>', '<?= esc($activity['nama_aktivitas']) ?>')">
                                            <i class="bi bi-play-circle me-2"></i>Tonton Video
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Modern Pagination -->
            <?php if (isset($lastPage) && $lastPage > 1): ?>
                <nav aria-label="Page navigation" class="mt-5">
                    <div class="pagination-modern d-flex justify-content-center align-items-center gap-2">
                        <?php if ($currentPage > 1): ?>
                            <a class="pagination-btn pagination-prev" href="<?= base_url('activities?page=' . ($currentPage - 1) . '&search=' . urlencode($search) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        <?php endif; ?>
                        
                        <?php for ($i = 1; $i <= $lastPage; $i++): ?>
                            <a class="pagination-btn <?= $i == $currentPage ? 'active' : '' ?>" 
                               href="<?= base_url('activities?page=' . $i . '&search=' . urlencode($search) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <?= $i ?>
                            </a>
                        <?php endfor; ?>
                        
                        <?php if ($currentPage < $lastPage): ?>
                            <a class="pagination-btn pagination-next" href="<?= base_url('activities?page=' . ($currentPage + 1) . '&search=' . urlencode($search) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                    
                    <div class="pagination-info text-center mt-3">
                        <span style="color: #1E3A8A; font-size: 0.9rem;">
                            Page <?= $currentPage ?> of <?= $lastPage ?>
                        </span>
                    </div>
                </nav>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Custom Styles -->
<style>
.modern-input {
    background: rgba(240, 248, 255, 0.8);
    border: 1px solid rgba(135, 206, 235, 0.3);
    border-radius: 12px;
    padding: 12px 16px;
    color: #1E3A8A;
    font-weight: 500;
    transition: all 0.3s ease;
}

.modern-input:focus {
    background: rgba(255, 255, 255, 0.95);
    border-color: #4169E1;
    box-shadow: 0 0 0 0.2rem rgba(65, 105, 225, 0.25);
    color: #1E3A8A;
    outline: none;
}

.modern-input::placeholder {
    color: rgba(30, 58, 138, 0.6);
}

.btn-modern {
    padding: 12px 24px;
    border-radius: 25px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
}

.btn-primary {
    background: linear-gradient(135deg, #87CEEB 0%, #4169E1 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(65, 105, 225, 0.3);
}

.btn-primary:hover {
    background: linear-gradient(135deg, #4169E1 0%, #87CEEB 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(65, 105, 225, 0.4);
    color: white;
}

.btn-video {
    background: rgba(135, 206, 235, 0.2);
    color: #4169E1;
    border: 1px solid rgba(135, 206, 235, 0.3);
    font-size: 0.9rem;
    padding: 8px 16px;
}

.btn-video:hover {
    background: #4169E1;
    color: white;
    border-color: #4169E1;
    transform: translateY(-2px);
}

.pagination-modern {
    flex-wrap: wrap;
}

.pagination-btn {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    background: rgba(255, 255, 255, 0.9);
    border: 1px solid rgba(135, 206, 235, 0.3);
    color: #1E3A8A;
    text-decoration: none;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    transition: all 0.3s ease;
}

.pagination-btn:hover {
    background: rgba(65, 105, 225, 0.1);
    border-color: #4169E1;
    color: #4169E1;
    transform: translateY(-2px);
}

.pagination-btn.active {
    background: linear-gradient(135deg, #87CEEB, #4169E1);
    border-color: transparent;
    color: white;
    box-shadow: 0 4px 15px rgba(65, 105, 225, 0.3);
}

.meta-item {
    transition: all 0.3s ease;
}

.meta-item:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 8px rgba(65, 105, 225, 0.1);
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .page-title {
        font-size: 2.5rem !important;
    }
    
    .filter-section {
        padding: 1.5rem !important;
    }
    
    .activity-image-container {
        height: 180px !important;
    }
    
    .btn-modern {
        padding: 10px 20px;
        font-size: 0.9rem;
    }
    
    .pagination-btn {
        width: 40px;
        height: 40px;
    }
}

@media (max-width: 576px) {
    .activity-content {
        padding: 1rem !important;
    }
    
    .meta-item {
        font-size: 0.8rem !important;
        padding: 3px 6px !important;
    }
    
    .date-badge {
        font-size: 0.75rem !important;
        padding: 6px 8px !important;
    }
}
</style>

<?= $this->endSection() ?>

